% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Pareto.R
\name{ILFPareto}
\alias{ILFPareto}
\title{Increased Limit Factor Curve from a Pareto severity distribution}
\usage{
ILFPareto(xLow, xHigh, scale, shape)
}
\arguments{
\item{xLow}{A positive real number -  the claim amount where the Increased Limit Factor Curve will be evaluated from.}

\item{xHigh}{A positive real number -  the claim amount where the Increased Limit Factor Curve will be evaluated to.}

\item{scale}{A positive real number - the scale parameter of the Claim Severity's Pareto distribution.}

\item{shape}{A positive real number - the shape parameter of the Claim Severity's Pareto distribution.}
}
\value{
The value of the Increased Limit Factor curve from \code{xLow} to \code{xHigh} with Claim Severity from a Pareto distribution with parameters \code{scale} and \code{shape}.
}
\description{
Increased Limit Factor Curve from a Pareto severity distribution
}
\examples{
ILFPareto(700,1200,500,1.2)
ILFPareto(1200,20000,200,1.1)
}
