% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ShinySimulatorGlobal.R
\name{apply_deductible_limit}
\alias{apply_deductible_limit}
\title{Apply a deductible and limit to claims}
\usage{
apply_deductible_limit(
  gross_claims_data,
  reinsurance_structure,
  deductible,
  limit
)
}
\arguments{
\item{gross_claims_data}{A vector of Claims.}

\item{reinsurance_structure}{The chosen reinsurance structure. Options are: 'No Reinsurance Structure', 'Unlimited Layer', 'Limited Layer', 'Exclude Layer'.}

\item{deductible}{The deductible of the reinsurance structure.}

\item{limit}{The limit of the reinsurance structure.}
}
\value{
The ceded claims for the structure, with the chosen deductible and limit.
}
\description{
Apply a deductible and limit to claims
}
\examples{
apply_deductible_limit(c(100, 50, 20), 'Limited Layer', 40, 20)
apply_deductible_limit(c(100, 50, 20), 'Limited Layer', 10, 30)
}
