% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NetworkToolbox--master.R
\name{Closeness}
\alias{Closeness}
\title{Closeness Centrality}
\usage{
Closeness(A, weighted = TRUE)
}
\arguments{
\item{A}{An adjacency matrix of network data}

\item{weighted}{Is the network weighted? Defaults to TRUE. Set to FALSE for unweighted measure of closeness centrality}
}
\value{
A vector of closeness centrality values for each node in the network
}
\description{
Computes closeness centrlaity of each node in a network
}
\examples{
\dontrun{

weighted_LC<-Closeness(A)

unweighted_LC<-Closeness(A,weighted=FALSE)
}
}
\references{
Rubinov, M., & Sporns, O. (2010). 
Complex network measures of brain connectivity: Uses and interpretations. 
Neuroimage, 52(3), 1059-1069.
}
\author{
Alexander Christensen <alexpaulchristensen@gmail.com>
}
