% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NetworkToolbox--master.R
\name{commboot}
\alias{commboot}
\title{Bootstrapped Communities Likelihood}
\usage{
commboot(data, normal = FALSE, n = nrow(data), iter = 100,
  filter = c("TMFG", "threshold"), method = c("louvain", "walktrap"),
  na.data = c("pairwise", "listwise", "fiml"), steps = 4, ...)
}
\arguments{
\item{data}{A set of data}

\item{normal}{Should data be transform to a normal distribution?
Defaults to FALSE. Data is not transformed to be normal.
Set to TRUE if data should be transformed to be normal}

\item{n}{Number of people to use in the bootstrap. Defaults to full sample size}

\item{iter}{Number of bootstrap iterations. Defaults to 100 iterations}

\item{filter}{Set filter method. Defaults to "TMFG"}

\item{method}{Defaults to "louvain". Set to "walktrap" for the walktrap algorithm}

\item{na.data}{How should missing data be handled?
For "pairwise" deletion \emph{na.rm} is applied.
If normal is TRUE, then "pairwise" is used.
For "listwise" deletion the \emph{na.omit} fucntion is applied.
Set to "fiml" for Full Information Maxmimum Likelihood (\emph{psych} package).
Full Information Maxmimum Likelihood is \strong{recommended} but time consuming}

\item{steps}{Number of steps to use in the walktrap algorithm. Defaults to 4. Use a larger number of steps for smaller networks}

\item{...}{Additional arguments for network filtering methods}
}
\value{
The factors and their proportion found across bootstrapped samples (i.e., their likelihood)
}
\description{
Bootstraps the sample with replace to compute walktrap reliability (still in testing phase)
}
\examples{
\dontrun{
commTMFG<-commboot(hex)

commThreshold<-commboot(hex,filter="threshold")
}
}
\references{
Blondel, V. D., Guillaume, J. L., Lambiotte, R., & Lefebvre, E. (2008).
Fast unfolding of communities in large networks.
\emph{Journal of Statistical Mechanics: Theory and Experiment}, \emph{2008}(10), P10008.

Csardi, G., & Nepusz, T. (2006).
The igraph software package for complex network research.
\emph{InterJournal, Complex Systems}, \emph{1695}(5), 1-9.
}
\author{
Alexander Christensen <alexpaulchristensen@gmail.com>
}
