% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/convertConnBrainMat.R
\name{convertConnBrainMat}
\alias{convertConnBrainMat}
\title{Import CONN Toolbox Brain Matrices to R format}
\usage{
convertConnBrainMat(MatlabData, progBar = TRUE)
}
\arguments{
\item{MatlabData}{Input for Matlab data file.
Defaults to interactive file choice}

\item{progBar}{Should progress bar be displayed?
Defaults to \code{TRUE}.
Set \code{FALSE} for no progress bar}
}
\value{
Returns a list containing:

\item{rmat}{Correlation matrices for each participant (m) in an array (n x n x m)}

\item{zmat}{Z-score matrices for each participant (m) in an array (n x n x m)}
}
\description{
Converts a Matlab brain z-score connectivity array (n x n x m)
where \strong{n} is the n x n connectivity matrices and \strong{m} is the participant.
If you would like to simply import a connectivity array from Matlab, then see the examples
}
\examples{
\dontrun{
neuralarray <- convertConnBrainMat()

#Import correlation connectivity array from Matlab
library(R.matlab)
neuralarray<-readMat(file.choose())
}

}
\author{
Alexander Christensen <alexpaulchristensen@gmail.com>
}
