% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/modues.R
\name{nlin_causality.test}
\alias{nlin_causality.test}
\title{A non linear Granger causality test}
\usage{
nlin_causality.test(ts1, ts2, lag, LayersUniv, LayersBiv, iters, bias = TRUE)
}
\arguments{
\item{ts1}{Numerical series}

\item{ts2}{Numerical series}

\item{lag}{The lag parameter}

\item{LayersUniv}{Integer vector of the size of hidden layers of the univariate model}

\item{LayersBiv}{Integer vector of the size of hidden layers of the bivariate model}

\item{iters}{The number of iterations}

\item{bias}{Logical argument  for the option of using the bias in the networks}
}
\value{
pvalue: the p-value of the test

Ftest:  the statistic of the test

summary ():  shows the test results

F-test (): returns the value of the test
}
\description{
A non linear Granger causality test
}
\details{
The test evaluates if the second time series causes the first one using a non-linear approach. The test evaluates two artificial neural network busing VARMLP model.
}
\examples{
library (timeSeries) # to extract time series
library (NlinTS)
data = LPP2005REC
model = nlin_causality.test (data[,1], data[,2], 2, c(2), c(4), 500, TRUE)
model$summary ()
}
