% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/modules.R
\name{causality.test}
\alias{causality.test}
\title{The Granger causality test}
\usage{
causality.test(ts1, ts2, lag, diff = FALSE)
}
\arguments{
\item{ts1}{Numerical dataframe containing one variable.}

\item{ts2}{Numerical dataframe containing one variable.}

\item{lag}{The lag parameter.}

\item{diff}{Logical argument for the option of making data stationary before making the test.}
}
\value{
gci: the Granger causality index.

Ftest:  the statistic of the test.

pvalue: the p-value of the test.

summary ():  shows the test results.
}
\description{
The Granger causality test
}
\details{
This is the classical Granger test of causality. The null hypothesis is that the second time series does not cause the first one
}
\examples{
library (timeSeries) # to extract time series
library (NlinTS)
data = LPP2005REC
model = causality.test (data[,1], data[,2], 2)
model$summary ()
}
\references{
{
  \insertRef{granger1980}{NlinTS}
}
}
