% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ph.R
\name{calc_ph_delta}
\alias{calc_ph_delta}
\title{Calculate the difference between pH and optimum}
\usage{
calc_ph_delta(
  B_LU_BRP,
  B_SOILTYPE_AGR,
  A_SOM_LOI,
  A_CLAY_MI,
  A_PH_CC,
  D_CP_STARCH,
  D_CP_POTATO,
  D_CP_SUGARBEET,
  D_CP_GRASS,
  D_CP_MAIS,
  D_CP_OTHER
)
}
\arguments{
\item{B_LU_BRP}{(numeric) The crop code from the BRP}

\item{B_SOILTYPE_AGR}{(character) The agricultural type of soil}

\item{A_SOM_LOI}{(numeric) The organic matter content of soil in percentage}

\item{A_CLAY_MI}{(numeric) The percentage A_CLAY_MI present in the soil}

\item{A_PH_CC}{(numeric) The pH-CaCl2 of the soil}

\item{D_CP_STARCH}{(numeric) The fraction of starch potatoes in the crop plan}

\item{D_CP_POTATO}{(numeric) The fraction of potatoes (excluding starch potatoes) in the crop plan}

\item{D_CP_SUGARBEET}{(numeric) The fraction of sugar beets in the crop plan}

\item{D_CP_GRASS}{(numeric) The fraction of grass in the crop plan}

\item{D_CP_MAIS}{(numeric) The fraction of mais in the crop plan}

\item{D_CP_OTHER}{(numeric) The fraction of other crops in the crop plan}
}
\value{
The difference between the actual and desired optimum soil pH. A numeric value.
}
\description{
This functions calculates the difference between the measured pH and the optimal pH according to the Bemestingsadvies
}
\examples{
calc_ph_delta(B_LU_BRP = 265, B_SOILTYPE_AGR = "rivierklei", A_SOM_LOI = 5,
A_CLAY_MI = 20,A_PH_CC = 6, D_CP_STARCH = 0,D_CP_POTATO = 0.3,D_CP_SUGARBEET = 0.2,
D_CP_GRASS = 0,D_CP_MAIS = 0.2,D_CP_OTHER = 0.3)
calc_ph_delta(265, "rivierklei", 5,20,6, 0,0.3,0.2,0,0.2,0.3) 

}
\references{
Handboek Bodem en Bemesting tabel 5.1, 5.2 en 5.3
}
