% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simpler_import_data.R
\name{simpler_import_data}
\alias{simpler_import_data}
\title{Download Open Case Study Simpler Import Data}
\usage{
simpler_import_data(casestudy, outpath = NULL)
}
\arguments{
\item{casestudy}{character string, name of the case study to pull data from.
The input name should follow the same naming scheme as the repository on GitHub:

ocs-bp-vaping-case-study

ocs-bp-opioid-rural-urban

ocs-bp-youth-disconnection}

\item{outpath}{character string, path to the directory where the downloaded
data folder should be saved to.}
}
\value{
If download is successful, the path to the downloaded data folder is
returned. Otherwise the appropriate error message is returned.
}
\description{
Download the specified case study simpler import data to use as you follow along the case study.
}
\details{
This function downloads the Open Case Study simpler import data
from GitHub and saves it in a new 'OCS_data/data/simpler_import/' folder in
the specified directory. This makes it so all the simpler import data
are easily available in a local folder to be processed and wrangled.
}
\examples{
tmp = tempfile()
dir.create(tmp)
simpler_import_data('ocs-bp-opioid-rural-urban', outpath = tmp)

}
