% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/online_ODT.R
\name{online.ODT}
\alias{online.ODT}
\title{using new training data to update an existing \code{ODT}.}
\usage{
\method{online}{ODT}(obj, X = NULL, y = NULL, weights = NULL, ...)
}
\arguments{
\item{obj}{an object of class \code{ODT}.}

\item{X}{An new n by d numeric matrix (preferable) or data frame  used to update the object of class \code{ODT}.}

\item{y}{A new response vector of length n used to update the object of class \code{ODT}.}

\item{weights}{Vector of non-negative observational weights; fractional weights are allowed (default NULL).}

\item{...}{optional parameters to be passed to the low level function.}
}
\value{
The same result as \code{ODT}.
}
\description{
Update existing \code{\link{ODT}} using new data to improve the model.
}
\examples{
# Classification with Oblique Decision Tree
data(seeds)
set.seed(221212)
train <- sample(1:209, 100)
train_data <- data.frame(seeds[train, ])
test_data <- data.frame(seeds[-train, ])
index <- seq(floor(nrow(train_data) / 2))
tree <- ODT(varieties_of_wheat ~ ., train_data[index, ], split = "gini")
online_tree <- online(tree, train_data[-index, -8], train_data[-index, 8])
pred <- predict(online_tree, test_data[, -8])
# classification error
(mean(pred != test_data[, 8]))

# Regression with Oblique Decision Tree
data(body_fat)
set.seed(221212)
train <- sample(1:252, 100)
train_data <- data.frame(body_fat[train, ])
test_data <- data.frame(body_fat[-train, ])
index <- seq(floor(nrow(train_data) / 2))
tree <- ODT(Density ~ ., train_data[index, ], split = "mse")
online_tree <- online(tree, train_data[-index, -1], train_data[-index, 1])
pred <- predict(online_tree, test_data[, -1])
# estimation error
mean((pred - test_data[, 1])^2)

}
\seealso{
\code{\link{ODT}} \code{\link{prune.ODT}} \code{\link{online.ODRF}}
}
\keyword{online}
\keyword{tree}
