% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/OmicsPLS.R
\name{impute_matrix}
\alias{impute_matrix}
\title{Impute missing values in a matrix}
\usage{
impute_matrix(X, ...)
}
\arguments{
\item{X}{A matrix with missing values in some entries.}

\item{...}{Further arguments for \code{softimpute}.}
}
\value{
An imputed version of matrix \eqn{X}
}
\description{
Impute missing values in a matrix
}
\details{
This function is based on the \code{\link{softImpute}} function in its eponymous package.
}
\examples{
X <- matrix(rnorm(20*100),20)
Xmis <- X
Xmis[sample(length(Xmis),length(Xmis)/10)] <- NA
anyNA(X)
anyNA(impute_matrix(Xmis))
}
