% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MyLM.R
\name{MyLM}
\alias{MyLM}
\title{MyLM}
\usage{
MyLM(Y, X, robust = F, betasonly = F, typicalSE = T)
}
\arguments{
\item{Y}{The Y variable}

\item{X}{A matrix of X variables}

\item{robust}{Should robust standard errors be calculated? Assumes a double entered twin dataset with twins evenly spaced in the dataset.}

\item{betasonly}{Should only the betas be returned? Good for bootstrapping}

\item{typicalSE}{Should the typical standard errors be included? Default is true. Can be true when robust is True.}
}
\value{
Returns a matrix of betas and standard errors
}
\description{
MyLM
}
\examples{
X<-DFSimulated(100,100,.4,.4)
Y<-RK(X[,1],X[,2],X[,3])
MyLM(Y[,1],Y[,c(2:3)],TRUE)
}
