% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotConceptCounts.R
\name{plotConceptCounts}
\alias{plotConceptCounts}
\title{Plot the concept counts of a summariseConceptCounts output.}
\usage{
plotConceptCounts(result, facet = NULL, colour = NULL)
}
\arguments{
\item{result}{A summarised_result object (output of summariseConceptCounts).}

\item{facet}{Columns to face by. Formula format can be provided. See possible
columns to face by with: \code{visOmopResults::tidyColumns()}.}

\item{colour}{Columns to colour by. See possible columns to colour by with:
\code{visOmopResults::tidyColumns()}.}
}
\value{
A ggplot2 object showing the concept counts.
}
\description{
Plot the concept counts of a summariseConceptCounts output.
}
\examples{
\donttest{
library(dplyr, warn.conflicts = FALSE)

cdm <- mockOmopSketch()

result <- cdm |>
  summariseConceptCounts(
    conceptId = list(
      "Renal agenesis" = 194152,
      "Manic mood" = c(4226696, 4304866, 37110496, 40371897)
    )
  )

result |>
  filter(estimate_name == "person_count", variable_name == "overall") |>
  plotConceptCounts(facet = "codelist_name", colour = "codelist_name")

PatientProfiles::mockDisconnect(cdm)
}
}
