% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summariseRecordCount.R
\name{summariseRecordCount}
\alias{summariseRecordCount}
\title{Summarise record counts of an omop_table using a specific time interval. Only
records that fall within the observation period are considered.}
\usage{
summariseRecordCount(
  cdm,
  omopTableName,
  interval = "overall",
  ageGroup = NULL,
  sex = FALSE,
  sample = NULL,
  dateRange = NULL
)
}
\arguments{
\item{cdm}{A cdm_reference object.}

\item{omopTableName}{A character vector of omop tables from the cdm.}

\item{interval}{Time interval to stratify by. It can either be "years", "quarters", "months" or "overall".}

\item{ageGroup}{A list of age groups to stratify results by.}

\item{sex}{Whether to stratify by sex (TRUE) or not (FALSE).}

\item{sample}{An integer to sample the tables to only that number of records.
If NULL no sample is done.}

\item{dateRange}{A list containing the minimum and the maximum dates
defining the time range within which the analysis is performed.}
}
\value{
A summarised_result object.
}
\description{
Summarise record counts of an omop_table using a specific time interval. Only
records that fall within the observation period are considered.
}
\examples{
\donttest{
library(dplyr, warn.conflicts = FALSE)

cdm <- mockOmopSketch()

summarisedResult <- summariseRecordCount(
  cdm = cdm,
  omopTableName = c("condition_occurrence", "drug_exposure"),
  interval = "years",
  ageGroup = list("<=20" = c(0,20), ">20" = c(21, Inf)),
  sex = TRUE
)

summarisedResult |>
  glimpse()

PatientProfiles::mockDisconnect(cdm = cdm)
}
}
