\name{generate.data}
\alias{generate.data}
\title{Generate random data from an oncogenetic tree}
\description{
  Generates random event occurrence data based on an oncogenetic
  tree model.
}
\usage{
generate.data(N, otree, with.errors=TRUE,
          edge.weights=if (with.errors) "estimated" else "observed")
}
\arguments{
  \item{N}{The required sample size.}
  \item{otree}{An object of the class \code{oncotree}.}
  \item{with.errors}{A logical value specifying whether false
  positive and negative errors should be applied.} 
  \item{edge.weights}{A choice of whether the observed or estimated
  edge transition probabilities should be used in the calculation
  of probabilities. See \code{\link{oncotree.fit}} for explanation
  of the difference. By default, estimated edge transition probabilies
 if \code{with.errors=TRUE} and the observed ones if 
 \code{with.errors=FALSE}.}
} 
\details{
  Technically, the  distribution generated by the
  tree is calculated exactly (using \code{\link{distribution.oncotree}}),
  and the observations are generated by sampling this distribution.
  Thus if \code{N} is small and \code{with.errors=TRUE}, it might
  be faster to avoid the computational overhead of calculating the
  entire distribution, but rather generate data not including 
  false positive/negatives and then randomly \sQuote{corrupt} it
  (see Examples below).
}
\value{
  A data set where each row is an independent observation.
}
\author{ Aniko Szabo }
\seealso{\code{\link{oncotree.fit}}}
\examples{
   data(ov.cgh)
   ov.tree <- oncotree.fit(ov.cgh)
   
   set.seed(7365)
   rd <- generate.data(200, ov.tree, with.errors=TRUE)
   
   #corrupt data - useful for small N
   system.time({
      rd2 <- generate.data(20, ov.tree, with.errors=FALSE);
      epos <- ov.tree$eps[["epos"]];
      eneg <- ov.tree$eps[["eneg"]];
      corrupt.data <- matrix(rbinom(prod(dim(rd2)),size=1,p=ifelse(rd2==0,epos,1-eneg)),
                          nr=nrow(rd2), nc=ncol(rd2), 
                          dimnames=list(NULL, names(rd2)))
     })
   system.time(generate.data(20, ov.tree, with.errors=TRUE))

}
\keyword{datagen}
\keyword{models}
