% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Optimal.rKJ.beta1.r
\name{Optimal.rKJ}
\alias{Optimal.rKJ}
\title{Optimal Two-Stage Design Using One-Sample Log-Rank Test with Restricted Follow-Up}
\usage{
Optimal.rKJ(dist, shape, S0, x0, hr, x, rate, alpha, beta)
}
\arguments{
\item{dist}{distribution options with 'WB' as Weibull, 'GM' as Gamma, 'LN' as log-normal, 'LG' as log-logistic for the baseline hazard function.}

\item{shape}{shape parameter for the baseline hazard function assuming one of the four parametric distributions ('WB', 'GM', 'LN' and 'LG').}

\item{S0}{survival probability at a fixed time point x0 under the null hypothesis.}

\item{x0}{a fixed time point where the survival probability is S0 under null.}

\item{hr}{the hazard ratio, s1=s0^hr where s1 is the survival probability under HA and s0 is that under H0.}

\item{x}{the restricted follow-up time period.}

\item{rate}{a constant accrual rate.}

\item{alpha}{type I error.}

\item{beta}{type II error.}
}
\value{
\emph{nsignle} the required sample size for the single-stage design.\cr
\emph{tasingle} the estimated accrual time for the single-stage design.\cr
\emph{csingle} the critical value for the single-stage design.\cr
\emph{n1} and \emph{n} required sample sizes in the two-stage design for interim and final stage, respectively.\cr
\emph{c1} and \emph{c} critical values in two-stage designs for the interim and final analysis, respectively.\cr
\emph{t1} the interim analysis time in the two-stage design.\cr
\emph{MTSL} the maximum total study length (the sum of accrual time and restricted follow-up time).\cr
\emph{ES} the expected sample size in the two-stage design.\cr
\emph{PS} the probability of early stopping under null in the two-stage design.
}
\description{
Optimal.rKJ() calculates the design parameters (e.g., t1, n1, n, c1, c) in the optimal two-stage design with restricted follow-up based on the one-sample log-rank (OSLR) test.
}
\examples{
\donttest{Optimal.rKJ(dist="WB", shape=1,S0=0.20,x0=2,hr=0.569,x=2,rate=5,alpha=0.05,
beta=0.2)}
# $param
# shape  S0    hr alpha beta rate x0 x
# 1     1 0.2 0.569  0.05  0.2    5  2 2
#
# $Single_stage
#     nsingle tasingle  csingle
# 1      32      6.4 1.644854
#
# $Two_stage
#   n1     c1  n     c     t1 MTSL      ES     PS
# 1 21 0.0355 33 1.633 4.1882  8.6 26.7993 0.5142

}
\references{
Wu, J, Chen L, Wei J, Weiss H, Chauhan A. (2020). Two-stage phase II survival trial design. Pharmaceutical Statistics. 2020;19:214-229. https://doi.org/10.1002/pst.1983
}
