% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/adj_range.R
\name{restrict_range}
\alias{restrict_range}
\alias{restrict_range.default}
\alias{restrict_range.OpenSpecy}
\alias{flatten_range}
\alias{flatten_range.default}
\alias{flatten_range.OpenSpecy}
\title{Range restriction and flattening for spectra}
\usage{
restrict_range(x, ...)

\method{restrict_range}{default}(x, ...)

\method{restrict_range}{OpenSpecy}(x, min, max, make_rel = TRUE, ...)

flatten_range(x, ...)

\method{flatten_range}{default}(x, ...)

\method{flatten_range}{OpenSpecy}(x, min = 2200, max = 2400, make_rel = TRUE, ...)
}
\arguments{
\item{x}{an \code{OpenSpecy} object.}

\item{min}{a vector of minimum values for the range to be flattened.}

\item{max}{a vector of maximum values for the range to be flattened.}

\item{make_rel}{logical; should the output intensities be normalized to the
range [0, 1] using \code{make_rel()} function?}

\item{\ldots}{additional arguments passed to subfunctions; currently not
in use.}
}
\value{
An \code{OpenSpecy} object with the spectral intensities within specified
ranges restricted or flattened.
}
\description{
\code{restrict_range()} restricts wavenumber ranges to user specified values.
Multiple ranges can be specified by inputting a series of max and min
values in order.
\code{flatten_range()} will flatten ranges of the spectra that should have no
peaks.
Multiple ranges can be specified by inputting the series of max and min
values in order.
}
\examples{
test_noise <- as_OpenSpecy(x = seq(400,4000, by = 10),
                           spectra = data.frame(intensity = rnorm(361)))
plot(test_noise)

restrict_range(test_noise, min = 1000, max = 2000)

flattened_intensities <- flatten_range(test_noise, min = c(1000, 2000),
                                       max = c(1500, 2500))
plot(flattened_intensities)

}
\seealso{
\code{\link{conform_spec}()} for conforming wavenumbers to be matched with
a reference library;
\code{\link{adj_intens}()} for log transformation functions;
\code{\link[base]{min}()} and \code{\link[base]{round}()}
}
\author{
Win Cowger, Zacharias Steinmetz
}
