% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/share_spec.R
\name{share_spec}
\alias{share_spec}
\alias{share_spec.default}
\alias{share_spec.OpenSpecy}
\title{Share data with the Open Specy community}
\usage{
share_spec(x, ...)

\method{share_spec}{default}(x, ...)

\method{share_spec}{OpenSpecy}(x, file = NULL, share = "system", credentials = NULL, ...)
}
\arguments{
\item{x}{a list object of class \code{OpenSpecy}.}

\item{file}{file to share (optional).}

\item{share}{accepts any local directory to save the spectrum for later
sharing via email to \email{wincowger@gmail.com}; \code{"system"} (default)
uses the Open Specy package directory at \code{system.file("extdata",
package = "OpenSpecy")}; if a correct API token exists, \code{"cloud"}
shares the spectrum with the cloud.}

\item{credentials}{a named list of credentials for cloud sharing; required if
\code{share = "cloud"}).}

\item{\ldots}{further arguments passed to the submethods.}
}
\value{
\code{share_spec()} returns only messages/warnings.
}
\description{
This helper function shares spectral data and metadata with the Open Specy
community.

\strong{Please note:} that \code{share_spec()} only provides basic sharing
functionality if used interactively. This means that files are only formatted
and saved for sharing but are not sent automatically. This only works with
hosted instances of Open Specy.
}
\examples{
\dontrun{
data("raman_hdpe")
share_spec(raman_hdpe,
           metadata = list(
             user_name = "Win Cowger",
             spectrum_type = "FTIR",
             spectrum_identity = "PE",
             license = "CC BY-NC"
           ))
}

}
\seealso{
\code{\link{read_text}()};
\code{\link[digest]{digest}()}; \code{\link[utils]{sessionInfo}()}
}
\author{
Zacharias Steinmetz, Win Cowger
}
