% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/OptHoldoutSize_estimation.R
\name{plot.optholdoutsize}
\alias{plot.optholdoutsize}
\title{Plot estimated cost function}
\usage{
\method{plot}{optholdoutsize}(x, ..., k2form = powerlaw)
}
\arguments{
\item{x}{Object of type \code{optholdoutsize}}

\item{...}{Other arguments passed to \code{plot()} and \code{lines()}}

\item{k2form}{Function governing expected cost to an individual sample given a predictive score fitted to n samples. Must take two arguments: n (number of samples) and theta (parameters). Defaults to a power-law form \verb{powerlaw(n,c(a,b,c))=a n^(-b) + c}.}
}
\value{
No return value; draws a plot only.
}
\description{
Plot estimated cost function, when parametric method is used for estimation.

Draws cost function as a line and indicates minimum. Assumes a power-law form of k2 unless parameter k2 is set otherwise.
}
\examples{

# Simple example

N=100000;
k1=0.3
A=8000; B=1.5; C=0.15; theta=c(A,B,C)

res1=optimal_holdout_size(N,k1,theta)

plot(res1)

}
\keyword{estimation}
