% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/list2df.R
\name{list2df}
\alias{list2df}
\title{Create \code{data.frame} from \code{list}}
\usage{
list2df(x, bind = c("rows", "cols"), ...)
}
\arguments{
\item{x}{A \code{list} object.}

\item{bind}{Binding direction. Available options are \code{"rows"} (default) and
\code{"cols"} for \code{\link[=rbind]{rbind()}} and \code{\link[=cbind]{cbind()}}, respectively.}

\item{...}{Additional arguments passed to \code{\link[=data.frame]{data.frame()}}.}
}
\value{
A \code{data.frame} object.
}
\description{
Create a \code{data.frame} from a \code{list} directly, i.e. without being required to
explicitly call \code{\link[=rbind]{rbind()}} first.
}
\examples{
lst <- list(letters[1:3], letters[4:6], letters[7:9])

do.call("rbind", lst) # results in matrix
list2df(lst)          # results in data.frame created using rbind()
list2df(lst, bind = "cols") # same for cbind()

}
