% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_age.R
\name{get_age}
\alias{get_age}
\title{Calculate age}
\usage{
get_age(birthdate, current_date, units = c("years", "months"))
}
\arguments{
\item{birthdate}{Date object giving the date of birth}

\item{current_date}{Date object giving the date from which age is to be
calculated}

\item{units}{The units in which age should be reported}
}
\value{
Numeric value giving age in the specified units.
}
\description{
Takes two Date objects and calculates age based on
\code{\link[base]{difftime}} (in days) divided by 365.2425 days per year (for
age in years) or 30.4375 days per month (for age in months).
}
\examples{
get_age(as.Date("2000-01-01"), Sys.Date(), "years")
}
