# ***********************************************************
# calcSum:
#   Compute a vector sum using a .C call to C code
# Argument:
#   x - a numeric vector
# -----------------------------------------------------------
calcSum <- function(x) {
  x <- as.vector(x); n <- length(x);
  if ( (n<0) | !is.numeric(x) ) return(NA)
  out <- .C("sum", as.double(x), as.integer(n),
            PACKAGE="PBStry")
  s <- out[[1]][1]
  return(s) }
