% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model_pin.R
\name{initials_pin_yz}
\alias{initials_pin_yz}
\title{Initial parameter sets of Yan and Zhang (2012)}
\usage{
initials_pin_yz(data, grid_size = 5, ea_correction = FALSE,
 verbose = TRUE)
}
\arguments{
\item{data}{A dataframe with 2 variables: the first
corresponds to buyer-initiated trades (buys), and the second corresponds
to seller-initiated trades (sells).}

\item{grid_size}{An integer between \code{1}, and \code{20};
representing the size of the grid. The default value is \code{5}. See
more in details.}

\item{ea_correction}{A binary variable determining whether the
modifications of the algorithm of \insertCite{Yan2012;textual}{PINstimation}
suggested by \insertCite{ErsanAlici2016;textual}{PINstimation} are
implemented. The default value is \code{FALSE}.}

\item{verbose}{a binary variable that determines whether information messages
about the initial parameter sets, including the number of the initial
parameter sets generated. No message is shown when \code{verbose} is set
to \code{FALSE}. The default value is \code{TRUE}.}
}
\value{
Returns a dataframe of initial sets each consisting of five
variables \{\eqn{\alpha}, \eqn{\delta}, \eqn{\mu}, \eb, \es\}.
}
\description{
Based on the grid search algorithm of
\insertCite{Yan2012;textual}{PINstimation}, generates
initial parameter sets for the maximum likelihood estimation of the \code{PIN}
model.
}
\details{
The argument 'data' should be a numeric dataframe, and contain
at least two variables. Only the first two variables will be considered:
The first variable is assumed to correspond to the total number of
buyer-initiated trades, while the second variable is assumed to
correspond to the total number of seller-initiated trades. Each row or
observation correspond to a trading day. \code{NA} values will be ignored.

The argument \code{grid_size} determines the size of the grid of the variables:
\code{alpha}, \code{delta}, and \code{eps.b}. If \code{grid_size} is set to a given value \code{m},
the algorithm creates a sequence starting from \code{1/2m}, and ending in
\code{1 - 1/2m}, with a step of \code{1/m}. The default value of \code{5} corresponds
to the size of the grid in \insertCite{Yan2012;textual}{PINstimation}.
In that case, the sequence starts at \code{0.1 = 1/(2 x 5)}, and ends in
\code{0.9 = 1 - 1/(2 x 5)} with a step of \code{0.2 = 1/m}.

The function \code{initials_pin_yz()} implements, by default, the original
\insertCite{Yan2012;textual}{PINstimation} algorithm as the default value of
\code{ea_correction} takes the value \code{FALSE}.
When the value of \code{ea_correction} is set to \code{TRUE}; then, sets
with irrelevant \code{mu} values are excluded, and sets with boundary values are
reintegrated in the initial parameter sets.
}
\examples{
# There is a preloaded quarterly dataset called 'dailytrades' with 60
# observations. Each observation corresponds to a day and contains the
# total number of buyer-initiated trades ('B') and seller-initiated
# trades ('S') on that day. To know more, type ?dailytrades

xdata <- dailytrades

# The function pin_yz() allows the user to directly estimate the PIN model
# using the full set of initial parameter sets generated using the algorithm
# of Yan and # Zhang (2012).
\donttest{
estimate.1 <- pin_yz(xdata, verbose = FALSE)
}
# Obtaining the set of initial parameter sets using initials_pin_yz allows
# us to estimate the PIN model using a subset of these initial sets.

initparams <- initials_pin_yz(xdata, verbose = FALSE)

# Use 10 randonly chosen initial sets from the dataframe 'initparams' in
# order to estimate the PIN model using the function pin() with custom
# initial parameter sets

numberofsets <- nrow(initparams)
selectedsets <- initparams[sample(numberofsets, 10),]

estimate.2 <- pin(xdata, initialsets = selectedsets, verbose = FALSE)

# Compare the parameters and the pin values of both specifications
\donttest{
comparison <- rbind(c(estimate.1@parameters, pin = estimate.1@pin),
                    c(estimate.2@parameters, estimate.2@pin))

rownames(comparison) <- c("all", "10")

show(comparison)
}

}
\references{
\insertAllCited
}
