% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TwoComp_Volume_Clearance.R
\name{TwoComp_Volume_Clearance}
\alias{TwoComp_Volume_Clearance}
\title{Convert pharmacokinetic parameters for two compartment model}
\usage{
TwoComp_Volume_Clearance(V1,V2,Cl1,Cl2,
                  V1.sd=NA,V2.sd=NA,Cl1.sd=NA,Cl2.sd=NA,
                  covar=c(V1V2=0,V1Cl1=0,V1Cl2=0,
                    V2Cl1=0,V2Cl2=0,Cl1Cl2=0))
}
\arguments{
\item{V1}{The volume of distribution of compartment 1}

\item{V2}{The volume of distribution of compartment 2}

\item{Cl1}{Clearance from compartment 1}

\item{Cl2}{Clearance from compartment 2}

\item{V1.sd}{standard error of V1}

\item{V2.sd}{standard error of V2}

\item{Cl1.sd}{standard error of Cl1}

\item{Cl2.sd}{standard error of Cl2}

\item{covar}{covariances among parameters}

\item{...}{arguments to be passed to methods}
}
\description{
Calculate pharmacokinetic parameters with volume of distributions (V1 and V2)
 and clearances (Cl1 and Cl2)
}
\examples{
TwoComp_Volume_Clearance(V1=5,V2=50,Cl1=3.5,Cl2=2.5,
         V1.sd=0.01,V2.sd=0.1,Cl1.sd=0.01,Cl2.sd=0.01)
}
\references{
\url{www.nonmemcourse.com/convert.xls}
}
