% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/oaks.R
\docType{data}
\name{oaks}
\alias{oaks}
\title{Oaks amplicon data set}
\format{
A data frame with 13 variables:
\itemize{
\item Abundance: A 114 taxa by 116 samples count matrix
\item Offset: A 114 taxa by 116 samples offset matrix
\item Sample: Unique sample id
\item tree: Tree status with respect to the pathogen (susceptible, intermediate or resistant)
\item branch: Unique branch id in each tree (4 branches were sampled in each tree, with 10 leaves per branch)
\item leafNO: Unique leaf id in each tree (40 leaves were sampled in each tree)
\item distTObase: Distance of the sampled leaf to the base of the branch
\item distTOtrunk: Distance of the sampled leaf to the base of the tree trunk
\item distTOground: Distance of the sampled leaf to the base of the ground
\item pmInfection: Powdery mildew infection, proportion of the upper leaf area displaying mildew symptoms
\item orientation: Orientation of the branch (South-West SW or North-East NE)
\item readsTOTfun: Total number of ITS1 reads for that leaf
\item readsTOTbac: Total number of 16S reads for that leaf
}
}
\source{
Data from B. Jakuschkin and coauthors.
}
\usage{
oaks
}
\description{
This data set gives the abundance of 114 taxa (66 bacterial OTU, 48 fungal OTUs) in 116 samples.
For each sample, 11 additional covariates are known.
}
\examples{
data(oaks)
\dontrun{
oaks_networks <- PLNnetwork(formula = Abundance ~ 1 + offset(log(Offset)), data = oaks)
}
}
\references{
Jakuschkin, B., Fievet, V., Schwaller, L. et al. Deciphering the Pathobiome: Intra- and Interkingdom Interactions Involving the Pathogen Erysiphe alphitoides . Microb Ecol 72, 870–880 (2016). \doi{10.1007/s00248-016-0777-x}
}
\seealso{
\code{\link[=prepare_data]{prepare_data()}}
}
\keyword{datasets}
