% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PLNfit-S3methods.R
\name{sigma.PLNfit}
\alias{sigma.PLNfit}
\title{Extract variance-covariance of residuals 'Sigma'}
\usage{
\method{sigma}{PLNfit}(object, ...)
}
\arguments{
\item{object}{an R6 object with class PLNfit}

\item{...}{additional parameters for S3 compatibility. Not used}
}
\value{
A semi definite positive matrix of size p, assuming there are p species in the model.
}
\description{
Extract the variance-covariance matrix of the residuals, usually noted \deqn{\Sigma} in PLN models. This captures the correlation between the species in the latent space.
}
\examples{
data(trichoptera)
trichoptera <- prepare_data(trichoptera$Abundance, trichoptera$Covariate)
myPLN <- PLN(Abundance ~ 1 + offset(log(Offset)), data = trichoptera)
sigma(myPLN) ## Sigma
}
\seealso{
\code{\link[=coef.PLNfit]{coef}}, \code{\link[=standard_error.PLNfit]{standard_error}} and \code{\link[=vcov.PLNfit]{vcov}} for other ways to access \deqn{\Sigma}.
}
