% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/osrtTest.R
\name{osrtTest}
\alias{osrtTest}
\alias{osrtTest.default}
\alias{osrtTest.formula}
\title{One-Sided Studentised Range Test}
\usage{
osrtTest(x, ...)

\method{osrtTest}{default}(x, g, ...)

\method{osrtTest}{formula}(formula, data, subset, na.action, ...)
}
\arguments{
\item{x}{a numeric vector of data values, or a list of numeric data
vectors.}

\item{\dots}{further arguments to be passed to or from methods.}

\item{g}{a vector or factor object giving the group for the
corresponding elements of \code{"x"}.
Ignored with a warning if \code{"x"} is a list.}

\item{formula}{a formula of the form \code{response ~ group} where
\code{response} gives the data values and \code{group} a vector or
factor of the corresponding groups.}

\item{data}{an optional matrix or data frame (or similar: see
\code{\link{model.frame}}) containing the variables in the
formula \code{formula}.  By default the variables are taken from
\code{environment(formula)}.}

\item{subset}{an optional vector specifying a 
subset of observations to be used.}

\item{na.action}{a function which indicates what should happen when
the data contain \code{NA}s.  Defaults to \code{getOption("na.action")}.}
}
\value{
A list with class \code{"htest"} containing the following components:
\describe{
 \item{method}{a character string indicating what type of test was performed.}
 \item{data.name}{a character string giving the name(s) of the data.}
 \item{statistic}{the estimated quantile of the test statistic.}
 \item{p.value}{the p-value for the test.}
 \item{parameter}{the parameters of the test statistic, if any.}
 \item{alternative}{a character string describing the alternative hypothesis.}
\item{estimates}{the estimates, if any.}
\item{null.value}{the estimate under the null hypothesis, if any.}
}
}
\description{
Performs Hayter's one-sided studentised range
test against an ordered alternative for normal data
with equal variances.
}
\examples{
osrtTest(weight ~ group, data = PlantGrowth)
}
\references{
A. J. Hayter (1990) A One-Sided Studentised Range
Test for Testing Against a Simple Ordered Alternative.
\emph{Journal of the American Statistical Association}
85, 778--785.
}
\keyword{htest}
