% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summaryPOUMM.R
\name{plot.summary.POUMM}
\alias{plot.summary.POUMM}
\title{Plot a summary of a POUMM fit}
\usage{
\method{plot}{summary.POUMM}(x, type = c("MCMC"), doPlot = TRUE,
  interactive = TRUE, stat = c("alpha", "theta", "sigma", "sigmae", "g0",
  "H2tMean"), chain = NULL, doZoomIn = FALSE,
  zoomInFilter = paste0("(stat \%in\% c('H2e','H2tMean','H2tInf','H2tMax') |",
  " (value >= HPDLower & value <= HPDUpper))"), ...)
}
\arguments{
\item{x}{An object of class POUMM.}

\item{type}{A character indicating the type of plot(s) to be generated.
Defaults to "MCMC", resulting in a trace and density plot for the selected
statistics (see argument stat). Currently, only 'MCMC' type is supported.}

\item{doPlot}{Logical indicating whether a plot should be printed on the 
currently active graphics device or whether to return a list of ggplot 
objects for further processing. Defaults to TRUE.}

\item{interactive}{Logical indicating whether the user should press a key 
before generating a next plot (when needed to display two or more plots).
Defaults to TRUE. Meaningless if 
doPlot = FALSE.}

\item{stat}{A character vector with the names of statistics to be plotted.
These should be names from the stats-list (see argument statFunctions).
Defaults to c("alpha", "theta", "sigma", "sigmae", "H2tMean", "H2tInf").}

\item{chain}{A vector of integers indicating the chains to be plotted.}

\item{doZoomIn}{(type MCMC only) A logical value indicating whether the 
produced plots should have a limitation on the x-axis according to an 
expression set in zoomInFilter (see below). Default value is FALSE.}

\item{zoomInFilter}{A character string which evaluates as logical value. If 
doZoomIn is set to TRUE, this filter is applied to each point in each MCMC
chain and the data-point is filtered out if it evaluates to FALSE. This 
allows to zoomIn the x-axis of density plots but should be use with caution,
since filtering out points from the MCMC-sample can affect the kernel densities.
Default value is 
 paste0("(stat %in% c('H2e','H2tMean','H2tInf','H2tMax') |",
        " (value >= HPDLower & value <= HPDUpper))").}

\item{...}{Not used; included for compatibility with the generic function plot.}
}
\value{
The function returns nothing if doPlot=TRUE; Otherwise, it returns a
 list with a data.table corresponding to the data passed to ggplot and two
 ggplot objects corresponding to an MCMC-trace and a posterior density plot.
}
\description{
Plot a summary of a POUMM fit
}

