% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/likPOUMM.R
\name{likPOUMMGivenTreeVTips}
\alias{likPOUMMGivenTreeVTips}
\alias{dVTipsGivenTreePOUMM}
\title{Density of observed tip-values given a tree, assuming Ornstein-Uhlenbeck 
process for the genetic contributions along the tree and normally distributed
environmental deviations.}
\usage{
likPOUMMGivenTreeVTips(
  z,
  tree,
  alpha,
  theta,
  sigma,
  sigmae = 0,
  g0 = NA,
  g0Prior = NULL,
  log = TRUE,
  pruneInfo = pruneTree(tree, z),
  usempfr = 0,
  maxmpfr = 2,
  precbits = 128,
  debug = FALSE
)
}
\arguments{
\item{z}{A numeric vector of size length(tree$tip.label) representing the
trait values at the tip-nodes.}

\item{tree}{an object of class phylo}

\item{alpha}{the strength of the selection}

\item{theta}{long term mean value of the OU process}

\item{sigma}{the unit-time standard deviation of the random component in the
OU process.}

\item{sigmae}{the standard deviation of the environmental deviation added to
the genetic contribution at each tip, by default 0, meaning no
environmental deviation.}

\item{g0}{Numeric, NA or NaN, either a fixed genotypic value at the root of 
tree or NA or NaN. A NA "Not Available" will cause to analytically
calculate the value of g0 that would maximize the conditional likelihood of
the data given g0. A NaN "Not a Number" will cause integration over g0
taking values in (-Inf,+Inf) assuming that g0 is normally distributed with
mean g0Prior$mean and variance g0Prior$var (see parameter g0Prior).}

\item{g0Prior}{Either NULL or a list with named numeric or character members
"mean" and "var". Specifies a prior normal distribution for the parameter g0.
If characters, the members mean and var are evaluated as R-expressions.}

\item{log}{Logical indicating whether log-likelihood should be returned
instead of likelihood, default is TRUE.}

\item{pruneInfo}{list returned by pruneTree(tree) to be passed in explicit
calls to dVGivenTreeOU.}

\item{usempfr}{integer indicating if and how mpfr should be used for small 
parameter values (any(c(alpha, sigma, sigmae) < 0.01)). Using the mpfr 
package can be forced by specifying an integer greater or equal to 2. 
Setting usempfr=0 (default) causes high precision likelihood 
calculation to be done on each encounter of parameters with at least 1 bigger
log-likelihood value than any of the currently found
maximum log-likelihood or the previously calculated log-likelihood value
Requires the Rmpfr package. Note that using mpfr may increase the time for 
one likelihood calculation more than 100-fold. Set usempfr to -1 or less
to completely disable Rmpfr functionality.}

\item{maxmpfr}{integer (not used)}

\item{precbits}{integer specifying precision bits for mpfr. Default is 512.}

\item{debug}{logical, if set to TRUE some debugging information is printed 
during likelihood calculation}
}
\value{
A numeric with attributes "g0" and "g0LogPrior".
}
\description{
Calculates the (log-)probability density of trait values at the
tip-nodes given the tree and assuming that the trait value at the tips is the
sum of a genetic contribution, g, that evolved on the tree according to an OU
process with parameters alpha, theta, sigma and an environmental deviation, 
e, that is distributed normally and independently between the tips of the 
tree. Note: Without additional assumptions for the distribution of the value
at the root of the tree, the likelihood is not defined at alpha=0, although 
this corresponds to the limiting Brownian motion process with mean value 
theta and unit time variance sigma^2. Considering the observed data and tree as
a fixed parameter and the POUMM parameters as variables, this function is
interpreted as the POUMM likelihood.
}
