#' Insurance Data
#'
#' Dataset \code{insurance} is a part of dataset imported from
#'  \code{insurance.csv} in  Kaggle "Medical Cost Personal Dataset".
#' This data source material comes from Machine Learning with R by Brett Lantz book.
#' It is simply come cleaned up and, it contains 1338 rows and 7 variables. These are:
#'
#' \itemize{
#' \item charges - Individual medical costs billed by health insurance.
#' \item age - age of primary beneficiary.
#' \item sex - insurance contractor gender, female, male.
#' \item bmi - Body mass index, providing an understanding of body, weights that are relatively high or low relative to height,
#' objective index of body weight (kg / m ^ 2) using the ratio of height to weight, ideally 18.5 to 24.9.
#' \item children - Number of children covered by health insurance / Number of dependents.
#' \item smoker - Smoking.
#' \item region - the beneficiary's residential area in the US, northeast, southeast, southwest, northwest.
#' }
#' Source: \url{https://www.kaggle.com/mirichoi0218/insurance}
#' @docType data
#' @keywords insurance
#' @name insurance
#' @source The \code{insurance.csv} dataset was downloaded from the \code{Kaggle} site.
#' The dataset was obtained from
#' \url{https://www.kaggle.com/mirichoi0218/insurance} on May 11, 2021.
#' @usage
#' data(insurance)
#' @format a data frame with 1338 rows and 7 columns.
NULL
