/*******************************************************************************
 * Copyright (c) 2017, College of William & Mary
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *     * Redistributions of source code must retain the above copyright
 *       notice, this list of conditions and the following disclaimer.
 *     * Redistributions in binary form must reproduce the above copyright
 *       notice, this list of conditions and the following disclaimer in the
 *       documentation and/or other materials provided with the distribution.
 *     * Neither the name of the College of William & Mary nor the
 *       names of its contributors may be used to endorse or promote products
 *       derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE COLLEGE OF WILLIAM & MARY BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * PRIMME: https://github.com/primme/primme
 * Contact: Andreas Stathopoulos, a n d r e a s _at_ c s . w m . e d u
 *******************************************************************************
 *   NOTE: THIS FILE IS AUTOMATICALLY GENERATED. PLEASE DON'T MODIFY
 ******************************************************************************/


#ifndef update_W_H
#define update_W_H
#if !defined(CHECK_TEMPLATE) && !defined(matrixMatvec_Sprimme)
#  define matrixMatvec_Sprimme CONCAT(matrixMatvec_,SCALAR_SUF)
#endif
#if !defined(CHECK_TEMPLATE) && !defined(matrixMatvec_Rprimme)
#  define matrixMatvec_Rprimme CONCAT(matrixMatvec_,REAL_SUF)
#endif
int matrixMatvec_dprimme(double *V, PRIMME_INT nLocal, PRIMME_INT ldV,
      double *W, PRIMME_INT ldW, int basisSize, int blockSize,
      primme_params *primme);
#if !defined(CHECK_TEMPLATE) && !defined(update_Q_Sprimme)
#  define update_Q_Sprimme CONCAT(update_Q_,SCALAR_SUF)
#endif
#if !defined(CHECK_TEMPLATE) && !defined(update_Q_Rprimme)
#  define update_Q_Rprimme CONCAT(update_Q_,REAL_SUF)
#endif
int update_Q_dprimme(double *V, PRIMME_INT nLocal, PRIMME_INT ldV,
      double *W, PRIMME_INT ldW, double *Q, PRIMME_INT ldQ, double *R, int ldR,
      double targetShift, int basisSize, int blockSize, double *rwork,
      size_t *rworkSize, double machEps, primme_params *primme);
int matrixMatvec_zprimme(PRIMME_COMPLEX_DOUBLE *V, PRIMME_INT nLocal, PRIMME_INT ldV,
      PRIMME_COMPLEX_DOUBLE *W, PRIMME_INT ldW, int basisSize, int blockSize,
      primme_params *primme);
int update_Q_zprimme(PRIMME_COMPLEX_DOUBLE *V, PRIMME_INT nLocal, PRIMME_INT ldV,
      PRIMME_COMPLEX_DOUBLE *W, PRIMME_INT ldW, PRIMME_COMPLEX_DOUBLE *Q, PRIMME_INT ldQ, PRIMME_COMPLEX_DOUBLE *R, int ldR,
      double targetShift, int basisSize, int blockSize, PRIMME_COMPLEX_DOUBLE *rwork,
      size_t *rworkSize, double machEps, primme_params *primme);
int matrixMatvec_sprimme(float *V, PRIMME_INT nLocal, PRIMME_INT ldV,
      float *W, PRIMME_INT ldW, int basisSize, int blockSize,
      primme_params *primme);
int update_Q_sprimme(float *V, PRIMME_INT nLocal, PRIMME_INT ldV,
      float *W, PRIMME_INT ldW, float *Q, PRIMME_INT ldQ, float *R, int ldR,
      double targetShift, int basisSize, int blockSize, float *rwork,
      size_t *rworkSize, double machEps, primme_params *primme);
int matrixMatvec_cprimme(PRIMME_COMPLEX_FLOAT *V, PRIMME_INT nLocal, PRIMME_INT ldV,
      PRIMME_COMPLEX_FLOAT *W, PRIMME_INT ldW, int basisSize, int blockSize,
      primme_params *primme);
int update_Q_cprimme(PRIMME_COMPLEX_FLOAT *V, PRIMME_INT nLocal, PRIMME_INT ldV,
      PRIMME_COMPLEX_FLOAT *W, PRIMME_INT ldW, PRIMME_COMPLEX_FLOAT *Q, PRIMME_INT ldQ, PRIMME_COMPLEX_FLOAT *R, int ldR,
      double targetShift, int basisSize, int blockSize, PRIMME_COMPLEX_FLOAT *rwork,
      size_t *rworkSize, double machEps, primme_params *primme);
#endif
