% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/makeFakeData.R
\name{makeFakeData}
\alias{makeFakeData}
\title{Make a data frame of fake item data}
\usage{
makeFakeData(
  n = 20,
  nitems = 9,
  values = 0:4,
  propmiss = 0.2,
  prefix = "q",
  id = FALSE
)
}
\arguments{
\item{n}{The number of respondents (rows) in the fake data.  The default is
\code{20}.}

\item{nitems}{The number of items in the fake data.  The default is
\code{9}.}

\item{values}{A vector of all possible values the items can take.  The
default is \code{0:4}, or equivalently \code{c(0, 1, 2, 3, 4)}.}

\item{propmiss}{The proportion of responses that will be randomly assigned to
be missing.  The default is \code{.20}.}

\item{prefix}{A quoted character that will be used to prefix the item
numbers.  The default is \code{"q"}.}

\item{id}{Logical, if \code{TRUE} the first variable in the data frame will
be a unique row \code{"ID"}.  The default is \code{FALSE}, and the
\code{"ID"} variable is omitted.}
}
\value{
A data frame with \code{n} rows, \code{nitems} items, and possibly
with some missing values randomly inserted.
}
\description{
\code{makeFakeData} creates a data frame containing fake item
data to facilitate the writing and testing of new scoring functions. It is
also used to create data for examples of scoring function usage.
}
\details{
The item responses in the first row are all the lowest possible
value and never \code{NA}, and the responses on the second row are all the
highest possible value and never \code{NA}.  This makes it easier to check
if the scoring function is at least getting the scores correct for subjects
with no missing values.  It also makes it easier in some cases to check
that the scoring function is properly reversing the items according to the
\code{itemsrev} argument of the scoring function.

Although the resulting data frame can be customized using the arguments,
the default values are sufficient for most generic testing purposes (see
example).
}
\examples{
makeFakeData()
}
