% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PSmethod.R
\name{PSmethod}
\alias{PSmethod}
\title{Fitting propensity score models with different methods}
\usage{
PSmethod(
  ps.formula = ps.formula,
  method = "glm",
  data = data,
  ncate = ncate,
  ...
)
}
\arguments{
\item{ps.formula}{an object of class \code{\link{formula}} (or one that can be coerced to that class):
a symbolic description of the propensity score model to be fitted. Additional details of model specification
are given under "Details". This argument is optional if \code{ps.estimate} is not \code{NULL}.}

\item{method}{a character to specify the method for estimating propensity scores. \code{"glm"} is default, and \code{"gbm"} and \code{"SuperLearner"} are also allowed.}

\item{data}{an optional data frame containing the variables in the propensity score model.}

\item{ncate}{a numeric to specify the number of treatment groups present in the given data.}

\item{...}{further arguments passed to or from other methods.}
}
\value{
\describe{

\item{\code{ e.h}}{a data frame of estimated propensity scores.}

\item{\code{ beta.h}}{estimated coefficient of the propensity model when \code{method = "glm"}.}

}
}
\description{
The function \code{PSmethod} is an internal function to estimate the propensity scores given a specified model through formula.
It is built into function \code{Sumstat}, \code{PStrim} and \code{PSweight}.
}
\details{
A typical form for \code{ps.formula} is \code{treatment ~ terms} where \code{treatment} is the treatment
variable and \code{terms} is a series of terms which specifies a linear predictor. \code{ps.formula} by default specifies generalized
linear models given the default argument \code{method = "glm"}.  It fits the logistic regression when \code{ncate = 2},and multinomial
logistic regression when \code{ncate > 2}. The argument \code{method} allows user to choose
model other than glm to fit the propensity score models. We have included \code{gbm} and \code{SuperLearner} as two alternative machine learning methods.
Additional arguments of the machine learning estimators can be supplied through the \code{...} argument. Note that SuperLearner does not handle multiple groups and the current version of multinomial
logistic regression is not supported by gbm. We suggest user to use them with extra caution. Please refer to the user manual of the \code{gbm} and \code{SuperLearner} packages for all the
allowed arguments.
}
\examples{
# the propensity model
ps.formula <- trt~cov1+cov2+cov3+cov4+cov5+cov6
psfit <- PSmethod(ps.formula = ps.formula,data = psdata,ncate=3)


}
