% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/jovanovicanalysis.r
\name{jovanovicanalysis}
\alias{jovanovicanalysis}
\title{Jovanovic Isotherm Analysis Non-Linear Form}
\usage{
jovanovicanalysis(Ce, Qe)
}
\arguments{
\item{Ce}{the numerical value for the equilibrium capacity}

\item{Qe}{the numerical value for the adsorpted capacity}
}
\value{
the nonlinear regression and the parameters for the Jovanovic isotherm
}
\description{
It is predicated on the assumptions contained in the Langmuir model, but in addition the possibility of some mechanical contacts between the adsorbate and adsorbent
}
\examples{
jovanovicanalysis(moringa$Ce, moringa$Qe)
}
\references{
:  Saadi, R., Saadi, Z., Fazaeli, R., Fard, N. E. (2015). Monolayer and multilayer adsorption isotherm models for sorption from aqueous media. Korean J. Chem. Eng., 32(5), 787-799 (2015) DOI: 10.1007/s11814-015-0053-7

:  Vargas, A., Cazetta, A., Kunita, M., Silva, T., Almeida V. (2011). Adsorption of methylene blue on activated carbon produced from ?amboyant pods (Delonix regia): Study of adsorption isotherms and kinetic models. Chemical Engineering Journal 168 (2011) 722-730
}
\author{
Christian Josuah F. Maylas

C.C. Deocaris
}
