% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/epa_createMonitorObject.R
\name{epa_createMonitorObject}
\alias{epa_createMonitorObject}
\title{Download and Convert Hourly EPA Air Quality Data}
\usage{
epa_createMonitorObject(year = NULL, parameterName = "PM2.5",
  parameterCode = "88101",
  baseUrl = "https://aqsdr1.epa.gov/aqsweb/aqstmp/airdata/",
  downloadDir = tempdir())
}
\arguments{
\item{year}{year}

\item{parameterName}{pollutant name}

\item{parameterCode}{pollutant code}

\item{baseUrl}{base URL for archived daily data}

\item{downloadDir}{directory where files are downloaded and unzipped}
}
\value{
A \emph{ws_monitor} object with EPA data.
}
\description{
Convert EPA data into a \emph{ws_monitor} object, ready for use with all \code{monitor_~} functions.
}
\note{
Before running this function you must first enable spatial data capabilities as in the example.
}
\examples{
\dontrun{
library(PWFSLSmoke)
library(MazamaSpatialUtils)
setSpatialDataDir('~/Data/Spatial')
loadSpatialData('NaturalEarthAdm1') # stateCodes dataset
mon <- epa_createMonitorObject(2015, "PM2.5", "88101")
}
}
\references{
\href{https://aqsdr1.epa.gov/aqsweb/aqstmp/airdata/download_files.html#Raw}{EPA AirData Pre-Generated Data Files}

\href{https://aqsdr1.epa.gov/aqsweb/aqstmp/airdata/FileFormats.html#_format_3}{file format description}
}
\keyword{EPA}
