% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/monitor_trim.R
\name{monitor_trim}
\alias{monitor_trim}
\title{Trim ws_monitor Time Axis to Remove NA Periods From Beginning and End}
\usage{
monitor_trim(ws_monitor)
}
\arguments{
\item{ws_monitor}{\emph{ws_monitor} object}
}
\value{
A \emph{ws_monitor} object with missing data trimmed.
}
\description{
Trims the time axis of a \emph{ws_monitor} object to exclude timestamps prior to the first and
after the last valid datapoint for any monitor.
}
\examples{
\dontrun{
sm13 <- wrcc_createMonitorObject(20150101, 20151231, stationID='sm13')
sm13$meta[,c('stateCode','countyName','siteName','monitorID')]
Deschutes <- monitor_subset(sm13, monitorIDs='Smoke..13__001')
Deschutes <- monitor_trim(Deschutes)
monitorPlot_dailyBarplot(Deschutes)
}
}
\keyword{ws_monitor}
