% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/openaq_createMetaDataframes.R
\name{openaq_createMetaDataframes}
\alias{openaq_createMetaDataframes}
\title{Create OpenAQ Site Location Metadata Dataframe}
\usage{
openaq_createMetaDataframes(df, parameters = NULL)
}
\arguments{
\item{df}{a OpenAQ dataframe after metadata enhancement}

\item{parameters}{pollutant name}
}
\value{
A \code{meta} dataframe for use in a \emph{ws_monitor} object.
}
\description{
After an OpenAQ dataframe has been enhanced with 
additional columns including \code{'datetime'}, \code{'stateCode'}, \code{'monitorID'} we are ready to 
pull out site information associated with unique monitorID.

These will be rearranged into a dataframe organized as deployment-by-property
with one row for each monitorID.

This site information found in \code{df} is augmented so that we end up with a uniform
set of properties associated with each monitorID. The list of
columns in the returned \code{meta} dataframe is:

\preformatted{
> names(meta)
[1] "siteName"    "latitude"    "longitude"   "timezone"    "countryCode" "stateCode"   "monitorID"
}
}
\keyword{OpenAQ}
