% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rawPlot_pollutionRose.R
\name{rawPlot_pollutionRose}
\alias{rawPlot_pollutionRose}
\title{Create Pollution Rose Plot from a Raw Dataframe}
\usage{
rawPlot_pollutionRose(df, parameter = "pm25", tlim = NULL,
  localTime = TRUE, normalize = FALSE, ...)
}
\arguments{
\item{df}{enhanced, raw dataframe as created by the \code{raw_enhance()} function}

\item{parameter}{parameter to plot}

\item{tlim}{optional vector with start and end times (integer or character representing YYYYMMDD[HH])}

\item{localTime}{logical specifying whether \code{tlim} is in local time or UTC}

\item{normalize}{normalize slices to fill entire area, allowing for easier comparison of counts of magnitudes by direction}

\item{...}{additional arguments to pass on to openair::pollutionRose()}
}
\description{
Create pollution rose plot from an enhanced raw dataframe.
This function is based on \code{openair::pollutionRose()}. If normalized, black line
indicates frequency by direction.
}
\note{
If more than one timezone is found, \code{localTime} is ignored and UTC is used.
}
\examples{
\dontrun{
raw <- airsis_createRawDataframe(20160901, 20161015, 'USFS', 1012)
raw <- raw_enhance(raw,rawSource='AIRSIS')
rawPlot_pollutionRose(raw)
}
}
\keyword{raw}

