% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tidy_toMonitor.R
\name{tidy_toMonitor}
\alias{tidy_toMonitor}
\title{Convert `ws_tidy` data to a `ws_monitor` object}
\usage{
tidy_toMonitor(data = NULL)
}
\arguments{
\item{data}{Data to potentially convert.}
}
\value{
`ws_monitor` object
}
\description{
Changes read-optomized 'tidy' formatted monitor data into a write-optomized
`ws_monitor` format. If the given data is already a `ws_monitor` object,
it is returned as is. This function is the inverse of \code{\link{monitor_toTidy}}.
}
\examples{
ws_monitor <- monitor_subset(
  Northwest_Megafires,
  monitorIDs = c('530470009_01', '530470010_01')
)

ws_monTidy <- monitor_toTidy(ws_monitor)
ws_monMon <- tidy_toMonitor(ws_monTidy)
head(ws_monMon$data)
head(ws_monitor$data)
}
