% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/monitor_distance.R
\name{monitor_distance}
\alias{monitor_distance}
\title{Calculate distances from monitors to a location of interest}
\usage{
monitor_distance(ws_monitor, longitude, latitude)
}
\arguments{
\item{ws_monitor}{\emph{ws_monitor} object}

\item{longitude}{longitude of the location of interest}

\item{latitude}{latitude of the location of interest}
}
\value{
Vector of of distances (km).
}
\description{
This function returns the distances (km) between monitoring
sites and a location of interest. These distances can be used to create a
mask identifying monitors within a certain radius of the location of interest.
}
\examples{
library(PWFSLSmoke)

N_M <- Northwest_Megafires
# Walla Walla
WW_lon <- -118.330278
WW_lat <- 46.065
distance <- monitor_distance(N_M, WW_lon, WW_lat)
closestIndex <- which(distance == min(distance))
distance[closestIndex]
N_M$meta[closestIndex,]
}
\seealso{
\code{\link{distance}}
}
\keyword{ws_monitor}
