% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/monitor_subsetData.R
\name{monitor_subsetData}
\alias{monitor_subsetData}
\title{Subset ws_monitor Object 'data' Dataframe}
\usage{
monitor_subsetData(
  data,
  tlim = NULL,
  vlim = NULL,
  monitorIDs = NULL,
  dropMonitors = FALSE,
  timezone = "UTC"
)
}
\arguments{
\item{data}{\emph{ws_monitor} object \code{data} dataframe}

\item{tlim}{optional vector with start and end times (integer or character representing YYYYMMDD[HH] or \code{POSIXct})}

\item{vlim}{optional vector with low and high data value limits}

\item{monitorIDs}{optional vector of monitorIDs}

\item{dropMonitors}{flag specifying whether to remove columns -- defaults to \code{FALSE}}

\item{timezone}{Olson timezone passed to \code{\link[MazamaCoreUtils]{parseDatetime}} when parsing numeric \code{tlim}}
}
\value{
A \emph{ws_monitor} object \code{data} dataframe, or \code{NULL} if filtering removes all monitors.
}
\description{
Subsets a \emph{ws_monitor} object's \code{data} dataframe by removing any monitors that
lie outisde the specified ranges of time and values and that are not mentioned in the
list of monitorIDs.

If \code{tlim} or \code{vlim} is not specified, it will not be used in the subsetting.

Intended for use by the monitor_subset function.
}
\details{
By default, filtering by tlim or vlim will always return a dataframe with the
same number of columns as the incoming dataframe. If \code{dropMonitors=TRUE}, columns
will be removed if there are not valid data for a specific monitor after subsetting.

Filtering by vlim is open on the left and closed on the right, i.e.

 \code{x > vlim[1] & x <= vlim[2]}
}
\keyword{ws_monitor}
