% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/addPolygon.R
\name{addPolygon}
\alias{addPolygon}
\title{Add a Colored Polygon to a Plot}
\usage{
addPolygon(x = 0, y = 0, sides = 72, radius = 1, rotation = 0,
  border = NULL, col = NA, ...)
}
\arguments{
\item{x}{x location of center}

\item{y}{y location of center}

\item{sides}{number of sides}

\item{radius}{radius}

\item{rotation}{amount to rotate the polygon in radians}

\item{border}{border color (see \code{?polygon})}

\item{col}{fill color (see \code{?polygon})}

\item{...}{additional arguments to be passed to \code{polygon()}}
}
\description{
Add a multi-sided polygon to a plot.
}
\examples{
# Create AQI dots
plot(1:6, rep(0,6), xlim=c(-1,7), ylim=c(-1,3),
    axes=FALSE, xlab='', ylab='', col='transparent')
for (i in 1:6) {
  addPolygon(i, 2, 72, 0.4, 0, col=PWFSLSmoke::AQI$colors[i])
  addPolygon(i, 1, 4, 0.4, pi/4, co=PWFSLSmoke::AQI$colors[i])
  addPolygon(i, 0, 3, 0.4, pi/2, col=PWFSLSmoke::AQI$colors[i])
}
}
\keyword{plotting}
