% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pamBinRead.R
\name{pamBinRead}
\alias{pamBinRead}
\title{Read Pamguard Binary Data}
\usage{
pamBinRead(
  fid,
  what = c("int8", "int16", "int32", "int64", "float", "double", "character"),
  n,
  seek = FALSE
)
}
\arguments{
\item{fid}{The binary file being read}

\item{what}{The type of data to read. Int64 is not handled natively
by R, see note.}

\item{n}{The number of objects to read.}

\item{seek}{Whether or not to just seek instead of reading}
}
\value{
Data of the type and number specified.
}
\description{
A wrapper for reading various types of binary data.
}
\note{
R does not natively support 64-bit integers. Current implementation
  is to read an int64 as 8 separate 1-byte raw pieces. These are converted
  from hexidecimal, shifted by the appropriate power of 2, then summed.
  Currently cannot read more than one int64 at a time, shouldn't be necessary.
}
\author{
Taiki Sakai \email{taiki.sakai@noaa.gov}
}
