% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Preprocessing.R
\name{DsmParallel}
\alias{DsmParallel}
\title{Dsmparallel computings}
\usage{
DsmParallel(outpath,mymodels,from=NULL,to=NULL)
}
\arguments{
\item{outpath}{: Output path of the result of the prediction file. The default is "output".}

\item{mymodels}{: The models were selected, including QRF,RF and MLR.}

\item{from}{: Which row to start cutting the matrix}

\item{to}{: Where does the last row of the cut matrix go}

}

\description{
Dsmparallel computings
}
\examples{
\donttest{
#####################################################################################
## Review the documentation for the Preprocess function before using this function ##
#####################################################################################

############################################################################
## This function is the main function that performs parallel computations ##
## The outpath field refers to the filename of the data output            ##
## The mymodels field has three modes to choose from: QRF,RF and MLR      ##
## ‘QRF’ stands for Random Forest Model Prediction Method                 ##
## ‘RF’ stands for Machine Learning Model Prediction Method               ##
## ‘MLR’ stands for Multiple Linear Regression Prediction Model           ##
## 'from' and 'to' are reserved fields that can be left unused by the user##
############################################################################
DsmParallel(outpath = "myoutputs",mymodels = "MLR",from=1,to=200)
}
}
\references{
Breiman, L. (2001). Random forests. Mach. Learn. 45, 5–32.
Meinshausen, N. (2006) "Quantile Regression Forests", Journal of Machine Learning Research 7,
983-999 http://jmlr.csail.mit.edu/papers/v7/
Song, X.D., Ge, G.Q., Zhang, G.L. and Wu, H.Y. ParallelDSM: A R package for parallel soil mapping. Computers & Geosciences (to be available in 2021)
}
