% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filterParams.R
\name{filterParams}
\alias{filterParams}
\title{Get parameter subset of only certain parameters.}
\usage{
filterParams(par.set, ids = NULL, type = NULL, tunable = c(TRUE, FALSE))
}
\arguments{
\item{par.set}{[\code{\link{ParamSet}}]\cr
Parameter set.}

\item{ids}{[\code{NULL} | \code{character}]\cr
Vector with id strings containing the parameters to select. Has to be a
subset of the parameter names within the parameter set.
Per default (\code{ids = NULL}) no filtering based on names is done.}

\item{type}{[\code{NULL} | \code{character}]\cr
Vector of allowed types, subset of: \dQuote{numeric}, \dQuote{integer}, \dQuote{numericvector},
\dQuote{integervector}, \dQuote{discrete}, \dQuote{discretevector}, \dQuote{logical},
\dQuote{logicalvector}, \dQuote{character}, \dQuote{charactervector},
\dQuote{function}, \dQuote{untyped}.
Setting \code{type = NULL}, which is the default, allows the consideration of all types.}

\item{tunable}{[\code{logical}]\cr
Vector of allowed values for the property \code{tunable}. Accepted arguments are
\code{TRUE}, \code{FALSE} or \code{c(TRUE, FALSE)}.
The default is \code{c(TRUE, FALSE)}, i.e. none of the parameters will be filtered out.}
}
\value{
[\code{\link{ParamSet}}].
}
\description{
Parameter order is not changed.
}
\examples{
ps = makeParamSet(
  makeNumericParam("u", lower = 1),
  makeIntegerParam("v", lower = 1, upper = 2),
  makeDiscreteParam("w", values = 1:2),
  makeLogicalParam("x"),
  makeCharacterParam("s"),
  makeNumericParam("y", tunable = FALSE)
)

# filter for numeric and integer parameters
filterParams(ps, type = c("integer", "numeric"))

# filter for tunable, numeric parameters
filterParams(ps, type = "numeric", tunable = TRUE)

# filter for all numeric parameters among "u", "v" and "x"
filterParams(ps, type = "numeric", ids = c("u", "v", "x"))
}

