% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LearnerParam.R, R/makeLearnerParamFuns.R
\name{LearnerParam}
\alias{LearnerParam}
\alias{makeDiscreteLearnerParam}
\alias{makeDiscreteVectorLearnerParam}
\alias{makeFunctionLearnerParam}
\alias{makeIntegerLearnerParam}
\alias{makeIntegerVectorLearnerParam}
\alias{makeLogicalLearnerParam}
\alias{makeLogicalVectorLearnerParam}
\alias{makeNumericLearnerParam}
\alias{makeNumericVectorLearnerParam}
\alias{makeUntypedLearnerParam}
\title{Create a description object for a parameter of a machine learning algorithm.}
\usage{
makeNumericLearnerParam(id, lower = -Inf, upper = Inf, allow.inf = FALSE,
  default, when = "train", requires = NULL, tunable = TRUE)

makeNumericVectorLearnerParam(id, len = as.integer(NA), lower = -Inf,
  upper = Inf, allow.inf = FALSE, default, when = "train",
  requires = NULL, tunable = TRUE)

makeIntegerLearnerParam(id, lower = -Inf, upper = Inf, default,
  when = "train", requires = NULL, tunable = TRUE)

makeIntegerVectorLearnerParam(id, len = as.integer(NA), lower = -Inf,
  upper = Inf, default, when = "train", requires = NULL, tunable = TRUE)

makeDiscreteLearnerParam(id, values, default, when = "train",
  requires = NULL, tunable = TRUE)

makeDiscreteVectorLearnerParam(id, len = as.integer(NA), values, default,
  when = "train", requires = NULL, tunable = TRUE)

makeLogicalLearnerParam(id, default, when = "train", requires = NULL,
  tunable = TRUE)

makeLogicalVectorLearnerParam(id, len = as.integer(NA), default,
  when = "train", requires = NULL, tunable = TRUE)

makeUntypedLearnerParam(id, default, when = "train", requires = NULL,
  tunable = TRUE)

makeFunctionLearnerParam(id, default, when = "train", requires = NULL)
}
\arguments{
\item{id}{[\code{character(1)}]\cr
Name of parameter.}

\item{lower}{[\code{numeric}]\cr
Lower bounds.
A singe value of length 1 is automatically replicated to \code{len} for vector parameters.
Default is \code{-Inf}.}

\item{upper}{[\code{numeric}]\cr
Upper bounds.
A singe value of length 1 is automatically replicated to \code{len} for vector parameters.
Default is \code{Inf}.}

\item{allow.inf}{[\code{logical(1)}]\cr
Allow infinite values for numeric and numericvector params to be feasible settings.
Default is \code{FALSE}.}

\item{default}{[any]\cr
Default value used in learner.
If this argument is missing, it means no default value is available.}

\item{when}{[\code{character(1)}]\cr
Specifies when parameter is used in the learner: \dQuote{train}, \dQuote{predict} or \dQuote{both}.
Default is \dQuote{train}.}

\item{requires}{[\code{NULL} | \code{call} | \code{expression}]\cr
States requirements on other parameters' values, so that setting
this parameter only makes sense if its requirements are satisfied (dependent parameter).
Can be an object created either with \code{expression} or \code{quote},
the former type is auto-converted into the later.
Only really useful if the parameter is included in a \code{\link{ParamSet}}.
Note that if your dependent parameter is a logical Boolean you need to verbosely write
\code{requires = quote(a == TRUE)} and not \code{requires = quote(a)}.
Default is \code{NULL} which means no requirements.}

\item{tunable}{[\code{logical(1)}]\cr
Is this parameter tunable?
Defining a parameter to be not-tunable allows to mark arguments like, e.g., \dQuote{verbose} or
other purely technical stuff, and allows them to be excluded from later automatic optimization
procedures that would try to consider all available parameters.
Default is \code{TRUE} (except for \code{untyped}, \code{function}, \code{character} and
\code{characterVector}) which means it is tunable.}

\item{len}{[\code{integer(1)}]\cr
Length of vector parameter.}

\item{values}{[\code{vector} | \code{list}]\cr
Possible discrete values. Instead of using a vector of atomic values,
you are also allowed to pass a list of quite \dQuote{complex} R objects,
which are used as discrete choices. If you do the latter,
the elements must be uniquely named, so that the names can be used
as internal representations for the choice.}
}
\value{
[\code{\link{LearnerParam}}].
}
\description{
This specializes \code{\link{Param}} by adding a few more attributes,
like a default value, whether it refers to a training or a predict function, etc.
}
\details{
The S3 class is a \code{\link{Param}} which additionally stores these elements:
\describe{
\item{default [any]}{See argument of same name.}
\item{has.default [\code{logical(1)}]}{Was a default value provided?}
\item{when [\code{character(1)}]}{See argument of same name.}
}
}

