% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PGPModel.R
\name{is.valid.PGP_Model}
\alias{is.valid.PGP_Model}
\title{Check if an object is a valid PGP_Model}
\usage{
is.valid.PGP_Model(x, comment = FALSE)
}
\arguments{
\item{x}{Object to be checked.}

\item{comment}{If FALSE then the function returns a boolean indicating whether \code{x} is a valid PGP_Model. If TRUE then the function returns a comment instead.}
}
\description{
Checks if an object is a PGP_Model object and whether it is valid for the use in functions like \code{Layer_Mean}
}
\examples{
PGPM <- PGP_Model(2, 1000, 1, 2, dispersion = 2)
PGPM
is.valid.PGP_Model(PGPM)
is.valid.PGP_Model(PGPM, comment = TRUE)

PGPM$alpha_tail <- -2
is.valid.PGP_Model(PGPM)
is.valid.PGP_Model(PGPM, comment = TRUE)

}
