% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Functions.R
\name{Pareto_Find_Alpha_btw_Layers}
\alias{Pareto_Find_Alpha_btw_Layers}
\title{Pareto Alpha Between Two Layers}
\usage{
Pareto_Find_Alpha_btw_Layers(
  Cover_1,
  AttachmentPoint_1,
  ExpLoss_1,
  Cover_2,
  AttachmentPoint_2,
  ExpLoss_2,
  max_alpha = 100,
  tolerance = 1e-10,
  truncation = NULL
)
}
\arguments{
\item{Cover_1}{Numeric. Cover of the first layer.}

\item{AttachmentPoint_1}{Numeric. Attachment point of the first layer.}

\item{ExpLoss_1}{Numeric. Expected loss of the first layer.}

\item{Cover_2}{Numeric. Cover of the second layer.}

\item{AttachmentPoint_2}{Numeric. Attachment point of the second layer.}

\item{ExpLoss_2}{Numeric. Expected loss of the second layer.}

\item{max_alpha}{Numeric. Upper limit for the alpha that is returned.}

\item{tolerance}{Numeric. Accuracy of the result.}

\item{truncation}{Numeric. If \code{truncation} is not \code{NULL} then the Pareto distribution is truncated at \code{truncation}.}
}
\value{
The Pareto alpha between the layer \code{Cover_1} xs \code{AttachmentPoint_1} with expected loss \code{ExpLoss_1}
and the layer  \code{Cover_2} xs \code{AttachmentPoint_2} with expected loss \code{ExpLoss_2}
}
\description{
Finds the Pareto alpha between two layers
}
\examples{
Pareto_Find_Alpha_btw_Layers(100, 100, 100, 200, 200, 50)
Pareto_Find_Alpha_btw_Layers(100, 100, 100, 200, 200, 50, truncation = 500)

}
\references{
Riegel, U. (2018) Matching tower information with piecewise Pareto. European Actuarial Journal 8(2): 437--460
}
