% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CollectiveModelMethods.R
\name{Simulate_Losses.PPP_Model}
\alias{Simulate_Losses.PPP_Model}
\title{Simulate Losses with a PPP_Model}
\usage{
\method{Simulate_Losses}{PPP_Model}(CollectiveModel, nyears = 1)
}
\arguments{
\item{CollectiveModel}{PPP_Model object.}

\item{nyears}{Integer. Number of simulated years.}
}
\value{
A matrix where row k contains the simulated losses of the kth simulated year.
}
\description{
Simulates losses with a PPP_Model
}
\examples{
PPPM <- PiecewisePareto_Match_Layer_Losses(c(1000, 2000, 3000), c(2000, 1000, 500),
                                           truncation = 10000, truncation_type = "wd")
PPPM
Simulate_Losses(PPPM, 100)

}
