% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/micro_array.R
\name{clustInference,micro_array,numeric-method}
\alias{clustInference,micro_array,numeric-method}
\alias{clustInference}
\alias{clustInference-methods}
\title{A function to explore a dataset and cluster its rows.}
\usage{
\S4method{clustInference}{micro_array,numeric}(microarray, vote.index, new.window = FALSE)
}
\arguments{
\item{microarray}{A microarray to cluster}

\item{vote.index}{Option for cluster attribution}

\item{new.window}{Boolean. New X11 window for plots. Defaults to FALSE.}
}
\value{
A list of two elements: \item{res.matrix}{A data.frame of
nrows(microarray) observations of 3 variables (name, cluster,
maj.vote.index).} \item{prop.matrix}{Additionnal info.}
}
\description{
Based on soft clustering performed by the Mfuzz package.
}
\examples{

library(Patterns)
if(require(CascadeData)){
data(micro_S, package="CascadeData")
D<-Patterns::as.micro_array(micro_S[1:20,],1:4,6)
b<-Patterns::clustInference(D,0.5)
b
}

}
\author{
Bertrand Frederic, Myriam Maumy-Bertrand.
}
\keyword{cluster}
